/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.aoe;

import com.google.common.collect.AbstractIterator;
import com.google.gson.JsonObject;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class VeiningAOEIterator
implements IAreaOfEffectIterator {
    public static final Loader LOADER = new Loader();
    private final int maxDistance;

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends IAreaOfEffectIterator> getLoader() {
        return LOADER;
    }

    @Override
    public Iterable<class_2338> getBlocks(IToolStackView tool, class_1799 stack, class_1657 player, class_2680 state, class_1937 world, class_2338 origin, class_2350 sideHit, IAreaOfEffectIterator.AOEMatchType matchType) {
        int expanded = tool.getModifierLevel(TinkerModifiers.expanded.getId());
        return VeiningAOEIterator.calculate(state, world, origin, this.maxDistance + expanded);
    }

    public static Iterable<class_2338> calculate(class_2680 state, class_1937 world, class_2338 origin, int maxDistance) {
        return () -> new VeiningIterator(world, origin, state.method_26204(), maxDistance);
    }

    public VeiningAOEIterator(int maxDistance) {
        this.maxDistance = maxDistance;
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<VeiningAOEIterator> {
        private Loader() {
        }

        @Override
        public VeiningAOEIterator deserialize(JsonObject json) {
            int maxDistance = JsonUtils.getIntMin(json, "max_distance", 0);
            return new VeiningAOEIterator(maxDistance);
        }

        @Override
        public VeiningAOEIterator fromNetwork(class_2540 buffer) {
            int maxDistance = buffer.method_10816();
            return new VeiningAOEIterator(maxDistance);
        }

        @Override
        public void serialize(VeiningAOEIterator object, JsonObject json) {
            json.addProperty("max_distance", (Number)object.maxDistance);
        }

        @Override
        public void toNetwork(VeiningAOEIterator object, class_2540 buffer) {
            buffer.method_10804(object.maxDistance);
        }
    }

    private static class VeiningIterator
    extends AbstractIterator<class_2338> {
        private final Set<class_2338> visited = new HashSet<class_2338>();
        private final Queue<DistancePos> queue = new ArrayDeque<DistancePos>();
        private final class_1937 world;
        private final class_2248 target;
        private final int maxDistance;

        private VeiningIterator(class_1937 world, class_2338 origin, class_2248 target, int maxDistance) {
            this.world = world;
            this.target = target;
            this.maxDistance = maxDistance;
            this.visited.add(origin);
            if (maxDistance > 0) {
                this.enqueueNeighbors(origin, 1);
            }
        }

        private void enqueueNeighbors(class_2338 pos, int distance) {
            for (class_2350 direction : class_2350.values()) {
                class_2338 offset = pos.method_10093(direction);
                if (this.visited.contains(offset)) continue;
                this.visited.add(offset);
                this.queue.add(new DistancePos(offset, distance));
            }
        }

        protected class_2338 computeNext() {
            while (!this.queue.isEmpty()) {
                DistancePos distancePos = this.queue.remove();
                class_2338 pos = distancePos.pos;
                if (!this.world.method_8320(pos).method_27852(this.target)) continue;
                int distance = distancePos.distance;
                if (distance < this.maxDistance) {
                    this.enqueueNeighbors(pos, distance + 1);
                }
                return pos;
            }
            return (class_2338)this.endOfData();
        }
    }

    private record DistancePos(class_2338 pos, int distance) {
    }
}

